<?php

if ( ! function_exists( 'roisin_core_add_icon_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param $widgets array
	 *
	 * @return array
	 */
	function roisin_core_add_icon_widget( $widgets ) {
		$widgets[] = 'RoisinCoreIconWidget';
		
		return $widgets;
	}
	
	add_filter( 'roisin_core_filter_register_widgets', 'roisin_core_add_icon_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class RoisinCoreIconWidget extends QodeFrameworkWidget {
		
		public function map_widget() {
			$widget_mapped = $this->import_shortcode_options( array(
				'shortcode_base' => 'roisin_core_icon'
			) );
			if( $widget_mapped ) {
				$this->set_base( 'roisin_core_icon' );
				$this->set_name( esc_html__( 'Roisin Icon', 'roisin-core' ) );
				$this->set_description( esc_html__( 'Add a icon element into widget areas', 'roisin-core' ) );
			}
		}
		
		public function render( $atts ) {
			
			$params = $this->generate_string_params( $atts );
			
			echo do_shortcode( "[roisin_core_icon $params]" ); // XSS OK
		}
	}
}
