<?php

if ( ! function_exists( 'roisin_core_add_social_share_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param $widgets array
	 *
	 * @return array
	 */
	function roisin_core_add_social_share_widget( $widgets ) {
		$widgets[] = 'RoisinCoreSocialShareWidget';
		
		return $widgets;
	}
	
	add_filter( 'roisin_core_filter_register_widgets', 'roisin_core_add_social_share_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class RoisinCoreSocialShareWidget extends QodeFrameworkWidget {
		
		public function map_widget() {
			$widget_mapped = $this->import_shortcode_options( array(
				'shortcode_base' => 'roisin_core_social_share'
			) );
			if( $widget_mapped ) {
				$this->set_base( 'roisin_core_social_share' );
				$this->set_name( esc_html__( 'Roisin Social Share', 'roisin-core' ) );
				$this->set_description( esc_html__( 'Add a social share element into widget areas', 'roisin-core' ) );
			}
		}
		
		public function render( $atts ) {
			$params = $this->generate_string_params( $atts );
			
			echo do_shortcode( "[roisin_core_social_share $params]" ); // XSS OK
		}
	}
}