<?php

if ( ! function_exists( 'roisin_core_add_spinners_options' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function roisin_core_add_spinners_options( $page ) {
		
		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_page_enable_loader',
					'title'         => esc_html__( 'Enable Page Loader', 'roisin-core' ),
					'description'   => esc_html__( 'Enable Page Loader Effect', 'roisin-core' ),
					'default_value' => 'no'
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_page_spinners',
					'title'       => esc_html__( 'Select Page Spinner Effect', 'roisin-core' ),
					'description' => esc_html__( 'Choose a loader spinner animation style', 'roisin-core' ),
					'options'     => array(
						''       				=> esc_html__( 'Default', 'roisin-core' ),
						'roisin_spinner'        => esc_html__( 'Roisin Spinner', 'roisin-core' ),
						'rotate_circles'        => esc_html__( 'Rotate Circles', 'roisin-core' ),
						'pulse'                 => esc_html__( 'Pulse', 'roisin-core' ),
						'double_pulse'          => esc_html__( 'Double Pulse', 'roisin-core' ),
						'cube'                  => esc_html__( 'Cube', 'roisin-core' ),
						'rotating_cubes'        => esc_html__( 'Rotating Cubes', 'roisin-core' ),
						'stripes'               => esc_html__( 'Stripes', 'roisin-core' ),
						'wave'                  => esc_html__( 'Wave', 'roisin-core' ),
						'two_rotating_circles'  => esc_html__( '2 Rotating Circles', 'roisin-core' ),
						'five_rotating_circles' => esc_html__( '5 Rotating Circles', 'roisin-core' ),
						'atom'                  => esc_html__( 'Atom', 'roisin-core' ),
						'clock'                 => esc_html__( 'Clock', 'roisin-core' ),
						'mitosis'               => esc_html__( 'Mitosis', 'roisin-core' ),
						'lines'                 => esc_html__( 'Lines', 'roisin-core' ),
						'fussion'               => esc_html__( 'Fussion', 'roisin-core' ),
						'wave_circles'          => esc_html__( 'Wave Circles', 'roisin-core' ),
						'pulse_circles'         => esc_html__( 'Pulse Circles', 'roisin-core' )
					),
					'dependency' => array(
						'hide' => array(
							'qodef_page_enable_loader' => array(
								'values'        => 'no',
								'default_value' => ''
							)
						)
					)
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_page_spinner_background_color',
					'title'       => esc_html__( 'Spinner Background Color', 'roisin-core' ),
					'description' => esc_html__( 'Choose the spinner background color', 'roisin-core' ),
					'dependency' => array(
						'hide' => array(
							'qodef_page_enable_loader' => array(
								'values'        => 'no',
								'default_value' => ''
							)
						)
					)
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_page_spinner_color',
					'title'       => esc_html__( 'Spinner Color', 'roisin-core' ),
					'description' => esc_html__( 'Choose the spinner color', 'roisin-core' ),
					'dependency' => array(
						'hide' => array(
							'qodef_page_enable_loader' => array(
								'values'        => 'no',
								'default_value' => ''
							)
						)
					)
				)
			);

			
			$page->add_field_element(
				array(
					'field_type'  => 'textarea',
					'name'        => 'qodef_roisin_spinner_svg',
					'title'       => esc_html__( 'Enter Spinner SVG Code', 'roisin-core' ),
					'dependency' => array(
						'show' => array(
							'qodef_page_spinners' => array(
								'values'        => 'roisin_spinner',
								'default_value' => ''
							)
						)
					)
				)
			);
		}
	}
	
	add_action( 'roisin_core_action_after_general_options_map', 'roisin_core_add_spinners_options' );
	add_action( 'roisin_core_action_after_general_page_meta_box_map', 'roisin_core_add_spinners_options', 9 );
}