<?php

if( ! function_exists('roisin_core_add_simple_social_links_widget')) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param $widgets array
	 *
	 * @return array
	 */
	function roisin_core_add_simple_social_links_widget($widgets) {
		$widgets[] = 'RoisinCoreSimpleSocialLinksWidget';
		
		return $widgets;
	}
	
	add_filter('roisin_core_filter_register_widgets','roisin_core_add_simple_social_links_widget');
}

if(class_exists('QodeFrameworkWidget')) {
	
	class RoisinCoreSimpleSocialLinksWidget extends QodeFrameworkWidget {
		
		public function map_widget() {
			$this->set_base('roisin_core_simple_social_links');
			$this->set_name( esc_html__('Roisin Simple Social Links', 'roisin-core'));
			$this->set_description( esc_html__( 'Add simple social link element into widget areas', 'roisin-core' ) );
			$this->set_widget_option(
				array(
					'field_type' => 'text',
					'name'       => 'simple_social_link_text',
					'title'      => esc_html__( 'Text', 'roisin-core' )
				)
			);
			$this->set_widget_option(
				array(
					'field_type' => 'text',
					'name'       => 'simple_social_link_link',
					'title'      => esc_html__( 'Link', 'roisin-core' )
				)
			);
		}
		
		public function render($atts) {
			?>
			<div class="widget qodef-simple-social-links">
                <?php if(!empty($atts['simple_social_link_link'])) { ?>
                    <a href="<?php echo esc_url($atts['simple_social_link_link']); ?>" target="_blank" class="qodef-simple-social-link">
                        <span class="qodef-simple-social-link-text"><?php echo esc_html($atts['simple_social_link_text']); ?></span>
                    </a>
                <?php } ?>
            </div>
			<?php
		}
	}
}