<?php
/*
Plugin Name: Roisin Core
Description: Plugin that adds portfolio post type, shortcodes and other modules
Author: Qode Themes
Version: 1.2
*/
if ( ! class_exists( 'RoisinCore' ) ) {
	class RoisinCore {
		private static $instance;

		function __construct() {
			// Include plugin core files.
			require_once __DIR__ . '/constants.php';

			// Permission 3 is set to be initialized before the qode-framework at priority 5.
			add_action( 'after_setup_theme', array( $this, 'require_core' ), 3 );

			add_filter( 'qode_framework_filter_register_admin_options', array( $this, 'create_core_options' ) );

			add_action( 'qode_framework_action_before_options_init_' . ROISIN_CORE_OPTIONS_NAME, array( $this, 'init_core_options' ) );

			add_action( 'qode_framework_action_populate_meta_box', array( $this, 'init_core_meta_boxes' ) );

			// Include plugin assets
			add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_assets' ) );

			// Make plugin available for translation
			add_action( 'init', array( $this, 'load_plugin_textdomain' ) );

			// Add plugin's body classes
			add_filter( 'body_class', array( $this, 'add_body_classes' ) );

			// Hook to include additional modules when plugin loaded
			do_action( 'roisin_core_action_plugin_loaded' );
		}

		public static function get_instance() {
			if ( null == self::$instance ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		function require_core() {
			
			require_once ROISIN_CORE_ABS_PATH . '/helpers/helper.php';

			// Hook to include additional files before modules inclusion
			do_action( 'roisin_core_action_before_include_modules' );

			foreach ( glob( ROISIN_CORE_INC_PATH . '/*/include.php' ) as $module ) {
				include_once $module;
			}

			// Hook to include additional files after modules inclusion
			do_action( 'roisin_core_action_after_include_modules' );
		}

		function create_core_options( $options ) {
			$roisin_core_options_admin = new QodeFrameworkOptionsAdmin(
				ROISIN_CORE_MENU_NAME,
				ROISIN_CORE_OPTIONS_NAME,
				array(
					'label' => esc_html__( 'Roisin Core Options', 'roisin-core' ),
				)
			);
			$options[]                 = $roisin_core_options_admin;

			return $options;
		}

		function init_core_options() {
			$qode_framework = qode_framework_get_framework_root();

			if ( ! empty( $qode_framework ) ) {
				$page = $qode_framework->add_options_page(
					array(
						'scope'       => ROISIN_CORE_OPTIONS_NAME,
						'type'        => 'admin',
						'slug'        => 'general',
						'title'       => esc_html__( 'General', 'roisin-core' ),
						'description' => esc_html__( 'Global Theme Options', 'roisin-core' ),
						'icon'        => 'fa fa-cog',
					)
				);

				// Hook to include additional options after default options
				do_action( 'roisin_core_action_default_options_init', $page );
			}
		}

		function init_core_meta_boxes() {
			do_action( 'roisin_core_action_default_meta_boxes_init' );
		}

		function enqueue_assets() {
			// CSS and JS dependency variables
			$style_dependency_array  = apply_filters( 'roisin_core_filter_style_dependencies', array( 'roisin-main' ) );
			$script_dependency_array = apply_filters( 'roisin_core_filter_script_dependencies', array( 'roisin-main-js' ) );

			// Hook to include additional scripts before plugin's main style
			do_action( 'roisin_core_action_before_main_css' );

			// Enqueue plugin's main style
			wp_enqueue_style( 'roisin-core-style', ROISIN_CORE_URL_PATH . 'assets/css/roisin-core.min.css', $style_dependency_array );

			// Enqueue plugin's 3rd party scripts
			wp_enqueue_script( 'jquery-ui-core' );
			wp_enqueue_script( 'jquery-easing-1.3', ROISIN_CORE_URL_PATH . 'assets/plugins/jquery/jquery.easing.1.3.js', array( 'jquery' ), false, true );
			wp_enqueue_script( 'modernizr', ROISIN_CORE_URL_PATH . 'assets/plugins/modernizr/modernizr.js', array( 'jquery' ), false, true );

			// Hook to include additional scripts before plugin's main script
			do_action( 'roisin_core_action_before_main_js' );

			// Enqueue plugin's main script
			wp_enqueue_script( 'roisin-core-script', ROISIN_CORE_URL_PATH . 'assets/js/roisin-core.min.js', $script_dependency_array, false, true );
		}

		function load_plugin_textdomain() {
			load_plugin_textdomain( 'roisin-core', false, ROISIN_CORE_REL_PATH . '/languages' );
		}

		function add_body_classes( $classes ) {
			$classes[] = 'roisin-core-' . ROISIN_CORE_VERSION;

			return $classes;
		}
	}
}

if ( ! function_exists( 'roisin_core_instantiate_plugin' ) ) {
	function roisin_core_instantiate_plugin() {
		RoisinCore::get_instance();
	}

	add_action( 'qode_framework_action_load_dependent_plugins', 'roisin_core_instantiate_plugin' );
}

if ( ! function_exists( 'roisin_core_check_requirements' ) ) {
	function roisin_core_check_requirements() {
		if ( ! defined( 'QODE_FRAMEWORK_VERSION' ) ) {
			add_action( 'admin_notices', 'roisin_core_admin_notice_content' );
		}
	}

	add_action( 'plugins_loaded', 'roisin_core_check_requirements' );
}

if ( ! function_exists( 'roisin_core_admin_notice_content' ) ) {
	function roisin_core_admin_notice_content() {
		echo sprintf( '<div class="notice notice-error"><p>%s</p></div>', esc_html__( 'Qode Framework plugin is required for Roisin Core plugin to work properly. Please install/activate it first.', 'roisin-core' ) );

		if ( function_exists( 'deactivate_plugins' ) ) {
			deactivate_plugins( plugin_basename( __FILE__ ) );
		}
	}
}
