jQuery(function ($) {
  'use strict';

  const API = (path) => `${CustomCheckout.restUrl}${path}`;

  function setStep(step) {
    $('#step-1,#step-2,#step-3').addClass('is-hidden');
    $('#step-' + step).removeClass('is-hidden');
    $('#stepper-1,#stepper-2,#stepper-3').removeClass('step-active').addClass('step-inactive').attr('aria-selected','false');
    $('#stepper-' + step).addClass('step-active').removeClass('step-inactive').attr('aria-selected','true');
    if (step === 3) $(document.body).trigger('update_checkout');
  }

  async function save(section, data) {
    return $.ajax({
      url: API('/save'),
      method: 'POST',
      data: JSON.stringify({ section, data }),
      contentType: 'application/json',
      headers: { 'X-WP-Nonce': CustomCheckout.nonce }
    });
  }

  function billingPayload() {
    return {
      first_name: $('#cc_billing_first_name').val(),
      last_name:  $('#cc_billing_last_name').val(),
      email:      $('#cc_billing_email').val(),
      phone:      $('#cc_billing_phone').val(),
      company:    $('#cc_billing_company').val(),
      address_1:  $('#cc_billing_address_1').val(),
      address_2:  $('#cc_billing_address_2').val(),
      city:       $('#cc_billing_city').val(),
      state:      $('#cc_billing_state').val(),
      postcode:   $('#cc_billing_postcode').val(),
      country:    $('#cc_billing_country').val()
    };
  }

  function shippingPayload() {
    const mode = $('#cc_fulfillment_mode').val() || 'pickup';
    const base = {
      order_comments: $('#cc_order_comments').val()
    };
    if (mode === 'delivery') {
      Object.assign(base, {
        first_name: $('#cc_shipping_first_name').val(),
        last_name:  $('#cc_shipping_last_name').val(),
        company:    $('#cc_shipping_company').val(),
        address_1:  $('#cc_shipping_address_1').val(),
        address_2:  $('#cc_shipping_address_2').val(),
        city:       $('#cc_shipping_city').val(),
        state:      $('#cc_shipping_state').val(),
        postcode:   $('#cc_shipping_postcode').val(),
        country:    $('#cc_shipping_country').val()
      });
    }
    return base;
  }

  function chooseMode(mode) {
    $('.cc-mode-card').removeClass('is-active').attr('aria-pressed','false');
    $('.cc-mode-card[data-mode="'+mode+'"]').addClass('is-active').attr('aria-pressed','true');
    $('#cc_fulfillment_mode').val(mode);
    if (mode === 'pickup') {
      $('#cc-shipping-fields').addClass('is-hidden');
    } else {
      $('#cc-shipping-fields').removeClass('is-hidden');
    }
    // Save immediately so shipping/tax refresh
    save('mode', { fulfillment_mode: mode }).always(() => {
      $(document.body).trigger('update_checkout');
    });
  }

  // init
  setStep(1);
  chooseMode('pickup');

  // events
  $('#stepper-1').on('click', () => setStep(1));
  $('#stepper-2').on('click', () => setStep(2));
  $('#stepper-3').on('click', () => setStep(3));

  $('#to-step-2').on('click', async () => {
    // Minimal client validation (expand as needed)
    if (!$('#cc_billing_first_name').val() || !$('#cc_billing_last_name').val() || !$('#cc_billing_email').val()) {
      alert('Please complete required billing fields.');
      return;
    }
    await save('billing', billingPayload());
    setStep(2);
  });

  $('#back-to-1').on('click', () => setStep(1));

  $('#to-step-3').on('click', async () => {
    const mode = $('#cc_fulfillment_mode').val();
    if (mode === 'delivery') {
      // basic checks
      if (!$('#cc_shipping_address_1').val() || !$('#cc_shipping_city').val() || !$('#cc_shipping_postcode').val() || !$('#cc_shipping_country').val()) {
        alert('Please complete required shipping address.');
        return;
      }
    }
    await save('shipping', shippingPayload());
    setStep(3);
  });

  $(document).on('click', '.cc-mode-card', function(){ chooseMode($(this).data('mode')); });

  // Keep totals current after any REST save (handled in .always above)
});
