<?php
defined( 'ABSPATH' ) || exit;

do_action( 'woocommerce_before_checkout_form', $checkout );

if ( ! $checkout->is_registration_enabled() && $checkout->is_registration_required() && ! is_user_logged_in() ) {
    echo esc_html( apply_filters( 'woocommerce_checkout_must_be_logged_in_message', __( 'You must be logged in to checkout.', 'woocommerce' ) ) );
    return;
}
?>
<div class="cc-wrap">
  <main class="cc-main">
    <nav class="cc-steps" role="tablist" aria-label="<?php esc_attr_e( 'Checkout Steps', 'custom-checkout' ); ?>">
      <button id="stepper-1" class="cc-stepper-btn step-active" type="button" role="tab" aria-selected="true" aria-controls="step-1"><?php esc_html_e( 'Billing', 'custom-checkout' ); ?></button>
      <button id="stepper-2" class="cc-stepper-btn step-inactive" type="button" role="tab" aria-selected="false" aria-controls="step-2"><?php esc_html_e( 'Shipping', 'custom-checkout' ); ?></button>
      <button id="stepper-3" class="cc-stepper-btn step-inactive" type="button" role="tab" aria-selected="false" aria-controls="step-3"><?php esc_html_e( 'Payment', 'custom-checkout' ); ?></button>
    </nav>

    <form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">

      <!-- STEP 1: OUR BILLING FORM -->
      <section id="step-1" class="cc-step" role="tabpanel" aria-labelledby="stepper-1">
        <div class="cc-grid-2">
          <p><label><?php _e('First name','custom-checkout'); ?><input type="text" id="cc_billing_first_name" required></label></p>
          <p><label><?php _e('Last name','custom-checkout'); ?><input type="text" id="cc_billing_last_name" required></label></p>
        </div>
        <div class="cc-grid-2">
          <p><label><?php _e('Email','custom-checkout'); ?><input type="email" id="cc_billing_email" required></label></p>
          <p><label><?php _e('Phone','custom-checkout'); ?><input type="tel" id="cc_billing_phone" required></label></p>
        </div>
        <div><label><?php _e('Company (optional)','custom-checkout'); ?><input type="text" id="cc_billing_company"></label></div>
        <div><label><?php _e('Address line 1','custom-checkout'); ?><input type="text" id="cc_billing_address_1" required></label></div>
        <div><label><?php _e('Address line 2','custom-checkout'); ?><input type="text" id="cc_billing_address_2"></label></div>
        <div class="cc-grid-3">
          <p><label><?php _e('City','custom-checkout'); ?><input type="text" id="cc_billing_city" required></label></p>
          <p><label><?php _e('State/Province','custom-checkout'); ?><input type="text" id="cc_billing_state" required></label></p>
          <p><label><?php _e('Postcode','custom-checkout'); ?><input type="text" id="cc_billing_postcode" required></label></p>
        </div>
        <div><label><?php _e('Country','custom-checkout'); ?><input type="text" id="cc_billing_country" placeholder="US" required></label></div>

        <div class="cc-actions">
          <span></span>
          <button type="button" id="to-step-2" class="button"><?php esc_html_e( 'Continue to Shipping', 'custom-checkout' ); ?></button>
        </div>
      </section>

      <!-- STEP 2: OUR SHIPPING (Pickup/Delivery + fields) -->
      <section id="step-2" class="cc-step is-hidden" role="tabpanel" aria-labelledby="stepper-2">
        <input type="hidden" id="cc_fulfillment_mode" value="pickup" />
        <div class="cc-cards">
          <button type="button" class="cc-mode-card is-active" data-mode="pickup" aria-pressed="true">
            <span class="cc-card-title"><?php esc_html_e( 'Pick up at store', 'custom-checkout' ); ?></span>
            <span class="cc-card-desc"><?php esc_html_e( 'Collect from our location', 'custom-checkout' ); ?></span>
          </button>
          <button type="button" class="cc-mode-card" data-mode="delivery" aria-pressed="false">
            <span class="cc-card-title"><?php esc_html_e( 'Delivery', 'custom-checkout' ); ?></span>
            <span class="cc-card-desc"><?php esc_html_e( 'Ship to your address', 'custom-checkout' ); ?></span>
          </button>
        </div>

        <div id="cc-shipping-fields" class="is-hidden">
          <div class="cc-grid-2">
            <p><label><?php _e('First name','custom-checkout'); ?><input type="text" id="cc_shipping_first_name"></label></p>
            <p><label><?php _e('Last name','custom-checkout'); ?><input type="text" id="cc_shipping_last_name"></label></p>
          </div>
          <div><label><?php _e('Company (optional)','custom-checkout'); ?><input type="text" id="cc_shipping_company"></label></div>
          <div><label><?php _e('Address line 1','custom-checkout'); ?><input type="text" id="cc_shipping_address_1"></label></div>
          <div><label><?php _e('Address line 2','custom-checkout'); ?><input type="text" id="cc_shipping_address_2"></label></div>
          <div class="cc-grid-3">
            <p><label><?php _e('City','custom-checkout'); ?><input type="text" id="cc_shipping_city"></label></p>
            <p><label><?php _e('State/Province','custom-checkout'); ?><input type="text" id="cc_shipping_state"></label></p>
            <p><label><?php _e('Postcode','custom-checkout'); ?><input type="text" id="cc_shipping_postcode"></label></p>
          </div>
          <div><label><?php _e('Country','custom-checkout'); ?><input type="text" id="cc_shipping_country" placeholder="US"></label></div>
        </div>

        <p><label><?php _e('Order notes (optional)','custom-checkout'); ?><textarea id="cc_order_comments" rows="3"></textarea></label></p>

        <div class="cc-actions">
          <button type="button" id="back-to-1" class="button button-secondary"><?php esc_html_e( 'Back', 'custom-checkout' ); ?></button>
          <button type="button" id="to-step-3" class="button"><?php esc_html_e( 'Continue to Payment', 'custom-checkout' ); ?></button>
        </div>
      </section>

      <!-- STEP 3: Native Woo payment only -->
      <section id="step-3" class="cc-step is-hidden" role="tabpanel" aria-labelledby="stepper-3">
        <h3 class="cc-section-title"><?php esc_html_e( 'Payment', 'custom-checkout' ); ?></h3>
        <?php wc_get_template( 'checkout/payment.php', [ 'checkout' => $checkout ] ); ?>
        <div class="cc-actions"><!-- no back button --></div>
      </section>

    </form>
  </main>

  <aside class="cc-aside">
    <div class="cc-summary">
      <h3 class="cc-summary-title"><?php esc_html_e( 'Order Summary', 'custom-checkout' ); ?></h3>
      <div id="order_review" class="woocommerce-checkout-review-order">
        <?php wc_get_template( 'checkout/review-order.php', [ 'checkout' => $checkout ] ); ?>
      </div>
    </div>
  </aside>
</div>

<?php do_action( 'woocommerce_after_checkout_form', $checkout ); ?>
